const Trader = require("../models/Trader");
const OTPController = require("../controllers/OTPController")
const Email = require("../controllers/email");
const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");
const ejs = require("ejs");
const path = require("path");
const { createCustomer } = require("./payment");
require('dotenv').config();
const { sendEmail } = require('../utils/sendEmail');
const {
  tradeApplicationApprovedUser,
  tradeApplicationRecievedUser,
  tradeApplicationRecievedAdmin
} = require('../email-templates/tradeApplicationEmail');
const { getIO } = require('../services/tradernotification');

// @route GET api/user
// @desc Returns all users
// @access Public


function generateOtp(length = 6) {
  let string = '1234567890';
  let code = '';
  Array.from({ length }).forEach(() => {
    code += string[Math.floor(Math.random() * string.length)];
  });
  return code;
}


exports.signup = async function (req, res) {
  console.log("nnnnnn", req.body)
  const body = req.body;
  const { email } = req.body;
  const oldexists = await Trader.findOne({ email });
  if (oldexists) {
    return res.status(409).json({ success: false, message: "Such email is already registered" });
  }

  Trader.findOne().sort({ createdAt: -1 }).exec(async (err, lastUser) => {
    if (err) {
      console.error("Error finding last user:", err);
      return res.status(500).json({ success: false, message: "Error finding last user" });
    }

    let accountNumber = 102000786;

    if (lastUser && lastUser.accountNumber) {
      // Convert the string accountNumber to a number
      const lastAccountNumber = parseInt(lastUser.accountNumber, 10);

      // Check if the conversion was successful
      if (!isNaN(lastAccountNumber)) {
        // Increment the accountNumber
        accountNumber = lastAccountNumber + 1;
      } else {
        console.error("Invalid account number:", lastUser.accountNumber);
      }
    }
    const { email, firstName } = body;
    const otp = generateOtp();
    console.log('New trader generated>>>', { ...body, otp });
    const trader = new Trader({ ...body, otp });

    try {
      const stripeCustomer = await createCustomer({ email, name: firstName });
      trader.stripeCustomerId = stripeCustomer.id;
      const savedTrader = await trader.save();
      console.log('Here is the customer ==>>', stripeCustomer);
      await Email.verifyUserEmail(body, trader);
      res.status(200).json({ message: "success", user: savedTrader });
    } catch (saveError) {
      console.error("Error saving user:", saveError);
      res.status(500).json({ success: false, message: "Error saving user" });
    }
  });
};



exports.VerifyEmail = async (req, res, next) => {
  const { otp, email } = req.params;
  console.log("I ran");
  try {
    // console.log("req.params.email", req.params.email);
    const oldtrader = await Trader.findOne({ email });
    if (!oldtrader) {
      return res.status(404).json({ success: false, message: "Trader not found" })
    }
    console.log(oldtrader);
    if (oldtrader.otp !== otp) {
      return res.status(401).json({ success: false, message: "Invalid OTP Entered" })
    }
    const trader = await Trader.findOneAndUpdate({ email }, { verified: true }, { new: true })
    const io = getIO();
    io.emit('server-notifications', {
      icon: 'mdi mdi-account-supervisor',
      message: `New trader registered: ${oldtrader.firstName}. Please accept or reject.`,
      redirect: '/SignupApproval',
      isViewed: false
    });
    await sendEmail({
      reciever: trader.email,
      subject: `${process.env.BUSINESS_NAME} || Trader Application Recieved`,
      htmlTemplate: tradeApplicationRecievedUser({ username: `${trader.firstName} ${trader.lastName}` })
    });
    await sendEmail({
      reciever: process.env.ADMIN_MAIL,
      subject: `${process.env.BUSINESS_NAME} || Trader Application Recieved`,
      htmlTemplate: tradeApplicationRecievedAdmin({ username: `${trader.firstName} ${trader.lastName}`, email: trader.email })
    });
    return res.status(200).json({ success: true, data: { _id: trader._id, }, message: "Email Verified Successfully", status: 200, });
  } catch (error) {
    console.log('Error verifying email', error);
    return next(error);
  }
};

exports.login = async function (req, res) {
  console.log("Abc===>>>", req.body)
  // const {password, email, } = req.body;  
  const email = req.body.email
  const password = req.body.password
  console.log("email===>>>", email, "password===>>>", password)
  try {
    const trader = await Trader.findOne({ email: { $regex: new RegExp(email, 'i') }, password: password, status: "active" })
    console.log("Response-Login=====>>>>", trader);
    if (trader === null) {
      console.log("err=====", err)
      res.json({ message: "Trader Not Found" })
    } else {
      console.log("user found", trader)
      res.status(200).json({ trader, message: "successLogin" })
    }
  } catch (error) {
    console.log("is match 1st error===>>>")
    res.status(404).json({ success: false, message: error.message });
  }
};





exports.GetSingleUser = async function (req, res) {
  console.log("Abc===>>>", req.params.id)

  try {
    const trader = await Trader.findOne({ _id: req.params.id })
    console.log("Response-Login=====>>>>", trader);
    if (trader === null) {
      console.log("err=====", err)
      res.json({ message: "Trader Not Found" })
    } else {
      console.log("user found", trader)
      res.status(200).json({ trader, message: "successLogin" })
    }
  } catch (error) {
    console.log("is match 1st error===>>>")
    res.status(404).json({ success: false, message: error.message });
  }
};



exports.GetAllInActiveUser = async function (req, res) {

  try {
    const trader = await Trader.find({ status: "inactive" })
    console.log("Response-Login=====>>>>", trader);
    if (trader === null) {
      console.log("err=====", err)
      res.json({ message: "Trader Not Found" })
    } else {
      console.log("user found", trader)
      res.status(200).json({ trader, message: "successLogin" })
    }
  } catch (error) {
    console.log("is match 1st error===>>>")
    res.status(500).json({ success: false, message: error.message });
  }
};


exports.GetAllUnCOD = async function (req, res) {

  try {
    const trader = await Trader.find({ status: "active", allowedCOD: false })
    console.log("Response-Login=====>>>>", trader);
    if (trader === null) {
      console.log("err=====", err)
      res.json({ message: "Trader Not Found" })
    } else {
      console.log("user found", trader)
      res.status(200).json({ trader, message: "Successfully found all traders" })
    }
  } catch (error) {
    console.log("is match 1st error===>>>")
    res.status(500).json({ success: false, message: error.message });
  }
};



exports.VerifyUserByAdmin = async function (req, res) {
  console.log("Abc===>>>", req.params.id)

  try {
    const trader = await Trader.findOneAndUpdate({ _id: req.params.id }, { status: "active" }, { new: true });
    console.log("abc====", trader)
    if (trader === null) {
      console.log("err=====", err)
      res.json({ message: "Trader Not Found" })
    } else {
      await sendEmail({
        reciever: trader.email,
        subject: `${process.env.BUSINESS_NAME} || Your Trader Application Has Been Approved`,
        htmlTemplate: tradeApplicationApprovedUser({ username: `${trader.firstName} ${trader.lastName}` })
      })
      console.log("user found", trader)
      res.status(200).json({ trader, message: "successLogin" })
    }
  } catch (error) {
    console.log("is match 1st error===>>>")
    res.status(404).json({ success: false, message: error.message });
  }
};


exports.AllowCOD = async function (req, res) {
  try {
    const id = req.params.id;
    if (!id) {
      return res.status(404).json({ message: 'Id must be provided' });
    }
    const updatedTrader = await Trader.findOneAndUpdate({ _id: id }, { allowedCOD: true }, { new: true });
    return res.status(200).json({ message: 'Trader is allowed Cash On Delivery', trader: updatedTrader });
  } catch (error) {
    console.log('Error Occured at allowing COD...', error);
    return res.status(500).json(error);
  }
}

exports.delete = async function (req, res) {
  try {
    const id = req.params.id;
    if (!id) {
      return res.status(404).json({ message: 'Id must be provided' });
    }
    await Trader.findOneAndDelete(id);
    return res.status(200).json({ message: 'Trader is deleted successfully' });
  } catch (error) {
    console.log('Error Occured at deleting trader...', error);
    return res.status(500).json(error);
  }
}

exports.autoLogin = async function (req, res) {
  try {
    const id = req.params.id
    if (!id) {
      return res.status(404).json({
        message: "Id must be provided"
      })
    }
    const trader = await Trader.findById(id)
    if (!trader) {
      return res.status(404).json({
        message: "Trader not found"
      })
    }
    res.status(200).json({
      message: "Trader found successfully.",
      trader
    })

  } catch (error) {
    return res.status(500).json({
      message: "Error in finding trader"
    })
  }
}


exports.getAllActiveTraders = async function (req, res) {
  try {
    const traders = await Trader.find({ status: "active" });
    return res.status(200).json({ success: true, message: "Successfully Retrieved Active Traders", traders });
  } catch (error) {
    return res.status(500).json({ success: false, message: error?.message ?? "Internal Server Error" })
  }
}

