
const pKey = require('../stripeKey');
const stripe = require('stripe')(pKey); 
const Customer = require('../models/customerModel');
const AppError = require('../utils/appError');
const catchAsync = require('../utils/catchAsync');
const Order = require('../controllers/order');
const {config} = require('dotenv');
config();


exports.getCheckoutSession = catchAsync(
  async (req, res, next) => {
    // 1) Get the currently booked tour
    // const CustomerLoggedIn = await Customer.findById(req.params.customerId);
    // console.log(tour);


    // console.log("Syed---->>>", req.body.data);
    let client = req.body.client || "web";  // web or trade

    // let distance = req.body.distance;
    let totalPrice = req.body.totalPrice;
    let deliveryPrice = req.body.deliverycharges
    
    // console.log("abc====", req.body.role)
    // console.log('delivery charges:====', deliveryPrice)
    let display_name;

    if (deliveryPrice === 0) {
      display_name = 'Free Delivery: Due to Total Purchase Over £15';
    } else {
      display_name = 'Delivery';
    }

    let id = await Order.postNewOrder(req);
    console.log("SavedSuccess====", id);
    console.log(req.body);

    console.log('Url == >> ',process.env.URL);
    const session = await stripe.checkout.sessions.create({
      payment_method_types: ['card'],
      success_url: `${client === "trade" ? process.env.TRADE_URL : process.env.URL}OrderComplete/${id._id}`,
      cancel_url: `${client === "trade" ? process.env.TRADE_URL : process.env.URL}`,
      mode: 'payment',

      line_items: req.body.data.map((comm) => ({
        price_data: {
          currency: 'gbp',
          product_data: {
            name: comm.subsubcatagory,
          },
          // unit_amount: comm.productPrice * 100,
          unit_amount: client === "trade" ?  Number.parseInt(comm.wholesellerPrice * 100,0) : Number.parseInt(comm.productPrice * 100,0),
        },
        quantity: comm.quantity,
      })),
      shipping_address_collection: {
        allowed_countries: ['GB'],
      },
      shipping_options: [
        {
          shipping_rate_data: {
            type: 'fixed_amount',
            fixed_amount: {
              amount: deliveryPrice,
              currency: 'gbp',
            },
            display_name: display_name,

          },
        }
      ],
    });

    let data = {
      ID: id._id,
      sessionID: session.id
    }
    console.log("Collected Shipping Info:", session.shipping);
    console.log("session.id:", session.id);
    let updatedStripeStatus = await Order.updateStripeStatusOrder(data);
    console.log("abc====", updatedStripeStatus)

    res.status(200).json({
      status: 'success',
      sessionId: session.id,
      session,
    });
  }
);
