const mongoose = require("mongoose");
const OrderSchema = new mongoose.Schema(
    {
        paymentType: {
            type: String,
            default: "stripe"
        },
        customerName: {
            type: String
        },
        customerEmail: {
            type: String
        },
        customerPhone: {
            type: String,
            default: ""
        },
        customerAddress: {
            type: String,
            default: ""
        },
        deliverycharges: {
            type:Number ,
            default: 0 
        },
        postalCode: {
            type: String,
            default: ""
        },
        discount: {
            type: Number,
            default: 0
        },
        paymentStatus: {
            type: String,
            default: "nopaid"
        },
        orderNumber: {
            type: Number,
            default: "0"
        },
        orderPlaceDate: {
            type: Date,
            default: function () {
                return new Date();
            }
        },
        productInfo: {
            type: Array
        },
        userid:{
            type: String,
            default: "0"
        },
        paymentSessionID: {
            type: String
        },
        readyStatus: {
            type: String,
            default: "active"
        },
        orderCancel: {
            type: Boolean,
            default: false
        },
        reasonCancel: {
            type: String,
            default: "false"
        },
        siteOrder: {
            type: String,
            enum:["retail","trade"],
            default:"retail"
        }
    }, {
    timestamps: true // Add this option to enable timestamps
});

module.exports = mongoose.model("Orders", OrderSchema);
