const mongoose = require('mongoose');
const Schema = mongoose.Schema;

// Define the schema for the Model
const ModelSchema = new Schema({
    title: {
        type: String,
        required: true
    },
    description: {
        type: String,
        required: true
    },
    link: {
        type: String,
        required: true
    },
    image: {
        type: String, // Assuming image is stored as a URL or path
        required: true
    },
    isMain: {
        type: Boolean,
        default: false
    }
});

// Export the Model schema as a Mongoose model
module.exports = mongoose.model('Model', ModelSchema);
