const SiteData = require('../models/SiteData');


// POST: /api/sitedata/create   

exports.create = async function (req, res) {
    const { siteName, siteLogo, email, phone, address, retailLink, tradeLink, dashboardLink, publicStripeKey, secretStripeKey, facebook, instagram, twitter, linkedin } = req.body;
    try {
        const oldData = await SiteData.findOne();
        if (oldData) {
            return res.status(400).json({ success: false, message: "Site Data already exists you have to update it!" });
        }
        const sitedata = await SiteData.create({
            siteName,
            siteLogo,
            email,
            phone,
            address,
            retailLink,
            tradeLink,
            dashboardLink,
            publicStripeKey,
            secretStripeKey,
            facebook,
            instagram,
            twitter,
            linkedin
        });
        if (!sitedata) {
            return res.status(500).json({ success: false, message: "Unable to create sitedata in database!" });
        }
        return res.status(201).json({ success: true, message: "Successfully created site data!", sitedata });
    } catch (error) {
        console.log('Error creating the sitedata', error);
        return res.status(500).json({ success: false, message: error?.message ?? "Internal Server Error" });
    }
}


// PUT: /api/sitedata/update

exports.update = async function (req, res) {
    const { siteName, siteLogo, email, phone, address, retailLink, tradeLink, dashboardLink, publicStripeKey, secretStripeKey, facebook, instagram, twitter, linkedin } = req.body;
    try {
        const oldData = await SiteData.findOne();
        if (!oldData) {
            return res.status(404).json({ success: false, message: "Site Data Not Found Please create one first!" });
        }
        const sitedata = await SiteData.findOneAndUpdate({ _id: oldData._id }, {
            siteName,
            siteLogo,
            email,
            phone,
            address,
            retailLink,
            tradeLink,
            dashboardLink,
            publicStripeKey,
            secretStripeKey,
            facebook,
            instagram,
            twitter,
            linkedin
        }, { new: true });
        if (!sitedata) {
            return res.status(500).json({ success: false, message: "Unable to update sitedata in database!" });
        }
        return res.status(200).json({ success: true, message: "Successfully updated site data!", sitedata });
    } catch (error) {
        console.log('Error updating the sitedata', error);
        return res.status(500).json({ success: false, message: error?.message ?? "Internal Server Error" });
    }
}


// GET: /api/sitedata/get

exports.get = async function (req,res){
    try {
        const sitedata = await SiteData.findOne();
        if(!sitedata){
            return res.status(200).json({ success: true, message: "Site data not found!" , sitedata:null});
        }
        return res.status(200).json({ success: true, message: "Site data found", sitedata });
    } catch (error) {
        console.log('Error getting the sitedata', error);
        return res.status(500).json({ success: false, message: error?.message ?? "Internal Server Error" });
    }
}



