const ImageKit = require("imagekit");
const dotenv = require("dotenv");
dotenv.config();

// const imagekit = new ImageKit({
//   publicKey: "public_RLsXVRDyhExv8BFYhSuuOzd3wkk=",
//   privateKey: "private_h7l9q8SCqAQJIak6h+gtCazIPqk=",
//   urlEndpoint: "https://ik.imagekit.io/qlgv36zdp/",
// });

const imagekit = new ImageKit({
  publicKey: process.env.IMAGE_KIT_PUBLIC_KEY,
  privateKey: process.env.IMAGE_KIT_PUBLIC_KEY,
  urlEndpoint: process.env.IMAGE_KIT_PUBLIC_KEY,
});

const testImageKitConnection = async () => {
  try {
    // Perform a simple operation to ensure connection is working
    const response = await imagekit.getAuthenticationParameters();
    console.log("ImageKit connected:", response);
  } catch (error) {
    console.error("Failed to connect to ImageKit:", error.message);
  }
};

module.exports = { imagekit, testImageKitConnection };
