const nodemailer = require('nodemailer');
require('dotenv').config();


const transporter = nodemailer.createTransport({
    host: process.env.EMAIL_HOST,
    port: 465,
    secure: true,
    auth: {
        user: process.env.EMAIL_USER,
        pass: process.env.EMAIL_PASS
    }
});



exports.sendEmail = async ({ reciever, subject, htmlTemplate }) => {
    try {
        await transporter.sendMail({
            from: process.env.EMAIL_USER,
            to: reciever,
            subject,
            html: htmlTemplate
        });
    } catch (error) {
        throw error;
    }
}


