const args = process.argv;

const path = require("path");
const bodyParser = require("body-parser");
const express = require("express");
const logger = require("morgan");
const cors = require("cors");
const dotenv = require("dotenv");
const connectDb = require("./config/db");
const user1 = require("./routes/user1");
const user = require("./routes/user");
const trader = require("./routes/trader");
const uploadRoute = require("./routes/upload.js");
const product = require("./routes/product");
const email = require("./routes/email");
const catagory = require("./routes/catagory");
const subcatagory = require("./routes/subcatagory");
const subsubcatagory = require("./routes/subsubcatagory");
const order = require("./routes/order");
const filters = require("./routes/filters");
const customerRoute = require("./routes/customerRoute");
const deliverycharges = require("./routes/deliverycharges");
const retailnewarival = require("./routes/retailnewarival");
const tradenewarrival = require("./routes/tradenewarrival");
const videoLanding = require("./routes/videoLanding");
const TraderOnOff = require("./routes/TraderOnOff");
const Subscriber = require("./routes/subscriber");
const Model = require("./routes/models");
const LTO = require("./routes/ltos");
const HotSelling = require("./routes/hotselling");
const Footer = require("./routes/footer");
const UploadIK = require("./routes/uploadImageKit");
const Admin = require('./routes/admin.js');
const Payment = require('./routes/payment.js');
const Address = require('./routes/address.js');
const SiteData = require('./routes/sitedata.js');
const Trade = require('./routes/trade.js');
const { setupTraderNotification } = require('./services/tradernotification');
const app = express();

app.use(bodyParser.json({ limit: '100mb' }));
// Configuring the Environment Variables
dotenv.config();

// dotenv.config({ path: "./config/.env" });

// BODYPARSER MIDDLEWARE
app.use(express.json());
// CORSs
app.use(cors());
app.use(logger("dev"));
// ROUTES
app.use("/api/user1", user1);
app.use("/api/user", user);
app.use("/api/trader", trader);
app.use("/api/product", product);
app.use("/api/upload", uploadRoute);
app.use("/api/email", email);
app.use("/api/catagory", catagory);
app.use("/api/subcatagory", subcatagory);
app.use("/api/subsubcatagory", subsubcatagory);
app.use("/api/order", order);
app.use("/api/filters", filters);
app.use('/api/customer', customerRoute);
app.use('/api/deliverycharges', deliverycharges);
app.use('/api/retailnewarival', retailnewarival);
app.use('/api/tradenewarrival', tradenewarrival);
app.use('/api/videoLanding', videoLanding);
app.use('/api/traderOnOff', TraderOnOff);
app.use('/api/subscribe', Subscriber);
app.use('/api/models', Model);
app.use('/api/ltos', LTO);
app.use('/api/hotselling', HotSelling);
app.use('/api/footer', Footer);
app.use('/api/uploadik', UploadIK);
app.use('/api/admin', Admin);
app.use('/api/payment', Payment);
app.use('/api/address', Address);
app.use('/api/sitedata', SiteData);
app.use('/api/trade', Trade);


//SERVE STATIC ASSET IF IN PRODUCTION

app.use("/assets", express.static("public"));

if (process.env.NODE_ENV === "production") {
  // SET STATIC FOLDER

  app.use(express.static("client/build"));
  app.get("*", (req, res) => {
    res.sendFile(path.resolve(__dirname, "client", "build", "index.html"));
  });
}

app.get('*', (req, res) => {
  res.status(404).json({ message: 'API is Working But Route Not Found' });
})

app.use((error, req, res, next) => {
  const message = error.message;
  const statusCode = error.statusCode || 500;
  res.status(statusCode).json({
    message: message,
  });
});

// CONFIGURE PORT
const PORT = process.env.PORT || args[2] || 5000;
const server = app.listen(PORT, "0.0.0.0", () => {
  // Db connection
  connectDb();

  console.log(
    `Server running in "${process.env.NODE_ENV}" mode on port "${PORT}"`
  );
  setupTraderNotification(server);
});

//Handle the promise rejection error
process.on("unhandledRejection", (err, promise) => {
  console.log("Error: ", err.message);
  server.close(() => process.exit(1));
});

