const express = require("express");
const Trader = require("../controllers/trader");
const router = express.Router();

router.post("/signup", Trader.signup);
router.put("/verifyEmail/:otp/:email", Trader.VerifyEmail);  // after verify email
router.post("/login", Trader.login);
router.get("/GetSingleUser/:id", Trader.GetSingleUser);


// Dashboard
router.get("/GetAllInActiveUser", Trader.GetAllInActiveUser);
router.get("/GetAllUnCOD", Trader.GetAllUnCOD);
router.patch("/VerifyUserByAdmin/:id", Trader.VerifyUserByAdmin);
router.patch("/AllowCOD/:id", Trader.AllowCOD);
router.delete("/delete/:id", Trader.delete);
router.get("/autologin/:id",Trader.autoLogin)
router.get("/getAllActiveTraders",Trader.getAllActiveTraders);

module.exports = router;
