const express = require('express');
const router = express.Router();
const modelController = require('../controllers/modelController');

// Routes
router.get('/getAll', modelController.getAllModels);
router.get('/:id', modelController.getModelById);
router.post('/create', modelController.createModel);
router.put('/update/:id', modelController.updateModel);
router.delete('/:id', modelController.deleteModel);
router.post('/setMain/:id', modelController.setMainModel);

module.exports = router;
