const VideoLanding = require("../models/VideoLanding");
const Type = require("../models/FilterType");
const Manufacturer = require("../models/FilterManufacture");
const Color = require("../models/FilterColor");
const Category = require("../models/FilterCategory");
const mongoose = require('mongoose');


exports.AddVideo = async function (req, res) {  
    let body = req.body; 
    try {   
        const videoLanding = new VideoLanding(body);
        const data = await videoLanding.save();
        res.status(200).json({ message: "success", data });
    } catch (error) {
      console.log("is match 1st error===>>>", error);
      res.status(500).json({ success: false, message: error.message });
    }
  };


exports.UpdateVideo = async function (req, res) {  
    const id = req.params.id;
    let body = req.body; 
    try {   
        if(!id){
          return res.status(404).json({message:'Error Id not found'});
        }
        const data = await VideoLanding.findByIdAndUpdate( id, body,{new:true});
        res.status(200).json({ message: "success", data });
    } catch (error) {
        console.log("is match 1st error===>>>", error);
        res.status(500).json({ success: false, message: error.message });
    }
};

exports.DeleteVideo = async function (req, res) {  
    const id = req.params.id;
    try {   
        if(!id){
          return res.status(404).json({message:'Error Id not found'});
        }
        const data = await VideoLanding.findByIdAndDelete(id);
        res.status(200).json({ message: "success", data });
    } catch (error) {
        console.log("is match 1st error===>>>", error);
        res.status(500).json({ success: false, message: error.message });
    }
};

  exports.GetAllVideo = async function (req, res) {   
    try {   
        const data = await VideoLanding.find();
        res.status(200).json({ message: "success", data });
    } catch (error) {
      console.log("is match 1st error===>>>", error);
      res.status(500).json({ success: false, message: error.message });
    }
  };
 