require('dotenv').config();
const stripe = require('stripe')(process.env.STRIPE_KEY);
const Payment = require('../models/Payment');
const Trader = require("../models/Trader");

// exports.MakePayment = async ( req,res) =>{
//     try{
//         const { paymentMethodId, amount, shipping, products, customerDetails, cardDetails } = req.body;
//         // console.log('Here is body==>>',req.body)
//         if(!paymentMethodId || !amount || shipping===undefined || !products || !customerDetails || !cardDetails){
//             return res.status(400).json({ message:'You must Provide all fields' });
//         }
//         const paymentIntent = await stripe.paymentIntents.create({
//             amount,
//             currency: 'gbp',
//             payment_method: paymentMethodId,
//             confirm:true,
//             automatic_payment_methods: {
//                 enabled: true,
//                 allow_redirects: 'never',
//             },
//         });

//         console.log('payment Intent ==>>',paymentIntent);
//         const payment = new Payment({
//             paymentMethodId,
//             amount,
//             shipping,
//             products,
//             customerDetails,
//             paymentStatus: paymentIntent.status,
//             cardDetails,
//         });
//         await payment.save();
//         return res.json({ success: true, paymentIntent });
//     }catch(error){
//         console.log('Error making payment==>>',error);
//         return res.status(500).json({ error: error.message ,message:'Internal Server Error'});
//     }
// }


exports.createCustomer = async ({email,name})=>{
    try {
        const customer = await stripe.customers.create({
            email,
            name,
        });
        return customer;
    } catch (error) {
        console.log('Error creating stripe customer',error);
    }
};

exports.MakePayment = async ( req,res) =>{
    try{
        const { paymentMethodId,customerId, amount, shipping, products, customerDetails, cardDetails } = req.body;
        // console.log('Here is body==>>',req.body)
        if(!paymentMethodId || !amount || shipping===undefined || !products || !customerDetails || !cardDetails){
            return res.status(400).json({ message:'You must Provide all fields' });
        }
        const paymentIntent = await stripe.paymentIntents.create({
            amount,
            currency: 'gbp',
            payment_method: paymentMethodId,
            customer: customerId,
            confirm:true,
            automatic_payment_methods: {
                enabled: true,
                allow_redirects: 'never',
            },
        });

        console.log('payment Intent ==>>',paymentIntent);
        const payment = new Payment({
            paymentMethodId,
            amount,
            shipping,
            products,
            customerDetails,
            paymentStatus: paymentIntent.status,
            cardDetails,
        });
        await payment.save();
        return res.json({ success: true, paymentIntent });
    }catch(error){
        console.log('Error making payment==>>',error);
        return res.status(500).json({ error: error.message ,message:'Internal Server Error'});
    }
}

exports.MakeSavedPayment = async ( req,res) =>{
    try{
        const { paymentMethodId,customerId, amount, shipping, products, customerDetails } = req.body;
        // console.log('Here is body==>>',req.body)
        if(!paymentMethodId || !amount || shipping===undefined || !products || !customerDetails ){
            return res.status(400).json({ message:'You must Provide all fields' });
        }
        const paymentIntent = await stripe.paymentIntents.create({
            amount,
            currency: 'gbp',
            payment_method: paymentMethodId,
            customer: customerId,
            confirm:true,
            automatic_payment_methods: {
                enabled: true,
                allow_redirects: 'never',
            },
        });

        console.log('payment Intent ==>>',paymentIntent);
        const payment = new Payment({
            paymentMethodId,
            amount,
            shipping,
            products,
            customerDetails,
            paymentStatus: paymentIntent.status
        });
        await payment.save();
        return res.json({ success: true, paymentIntent });
    }catch(error){
        console.log('Error making payment==>>',error);
        return res.status(500).json({ error: error.message ,message:'Internal Server Error'});
    }
}


exports.getSavedPaymentMethods = async (req, res) => {
    try {
        const userId = req.params.userId; 
        const payments = await Payment.find({ "customerDetails.id": userId }); 
        res.json({ success: true, payments });
    } catch (error) {
        console.error(error);
        res.status(500).json({ error: error.message });
    }
};



exports.savePaymentMethod = async (req, res) => {
    try {
        const { customerId, paymentMethodId } = req.body;
        const paymentMethod = await stripe.paymentMethods.attach(paymentMethodId, {
            customer: customerId,
        });
        await stripe.customers.update(customerId, {
            invoice_settings: {
                default_payment_method: paymentMethodId,
            },
        });
        res.json({ success: true, paymentMethod });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

exports.getSavedPaymentMethods = async (req, res) => {
    try {
        const traderId = req.params.traderId;

        const trader = await Trader.findById(traderId);
        if(!trader.stripeCustomerId){
            const stripeCustomer = await createCustomer({email:trader.email,name:trader.firstName});
            trader.stripeCustomerId = stripeCustomer.id;
            await trader.save();
        }
        const customerId = trader.stripeCustomerId;

        const paymentMethods = await stripe.paymentMethods.list({
            customer: customerId,
            type: 'card',
        });

        res.json({ success: true, paymentMethods });
    } catch (error) {
        console.log('Error geting payment methods',error);
        res.status(500).json({ error: error.message });
    }
};







exports.registerStripeCustomer = async (req,res) => {
    try {
        const traderId = req.params.traderId;
        const trader = await Trader.findById(traderId);
        if(!trader.stripeCustomerId){
            const stripeCustomer = await createCustomer({email:trader.email,name:trader.firstName});
            trader.stripeCustomerId = stripeCustomer.id;
            await trader.save();
        }
        return res.status(200).json({success:true,message:'The trader has been registered with the stripe successfully.'});
    } catch (error) {
        console.log('Error creating stripe customer',error);
        return res.status(500).json({success:false,message:'Error registering trader with the stripe. Please try again.'});
    }
};






