const express = require("express");

const filter = require("../controllers/Filter");

const router = express.Router();

router.post("/addvariant", filter.addVariant);
router.put("/updatevariant/:id", filter.updateVariant);
router.get("/getvariant", filter.getAllVariants);
router.get("/getVarientbyString/:data", filter.getVarientbyString);  // dashboard
router.delete("/deletevarient/:id", filter.deletevarient);


router.post("/addmanufacturer", filter.addManufacturer);
router.put("/updatemanufacturer/:id", filter.updateManufacturer);
router.get("/getmanufacturer", filter.getAllManufacturer);
router.get("/getManufacturebyString/:data", filter.getManufacturebyString);  // dashboard
router.delete("/deletemanufacturer/:id", filter.deletemanufacturer);




router.post("/addtype", filter.addType);
router.get("/gettype", filter.gettype);
router.get("/gettypebyString/:data", filter.gettypebyString);  // dashboard 
router.delete("/deletetype/:id", filter.deletetype);
router.patch("/updatetypeONOFF/:id", filter.updatetypeONOFF);
router.patch("/updatetype/:id", filter.updatetype);







router.post("/addcategory", filter.addCategory);
router.get("/getcategories", filter.getAllCategories);



router.post("/addcolor", filter.addColor);
router.put("/updatecolor/:id", filter.updateColor);
router.get("/getcolor", filter.getAllColors);
router.get("/getColorbyString/:data", filter.getColorbyString);  // dashboard
router.delete("/deletecolor/:id", filter.deletecolor);
router.put("/updateSequence", filter.updateSequence);  // New Route to exchange types position



router.get("/gettypePermitedToShow", filter.gettypePermitedToShow);    // retail
router.get("/gettypePermitedToShowTrade", filter.gettypePermitedToShowTrade);    // Trade

router.get("/getNavBarDataForRetail", filter.getNavBarDataForRetail);  // retail
router.get("/getNavBarDataForTrade", filter.getNavBarDataForTrade) // trade



// Keyword search Functionality;;
router.post('/searchRetail', filter.keywordSearchRetail);
router.post('/searchTrade', filter.keywordSearchTrade);
router.post('/searchDash', filter.keywordSearchDash);



module.exports = router;
