const Products = require("../models/Product");
const SubSubCatagory = require("../models/SubSubCatagory");
const SubCatagory = require("../models/SubCatagory");
const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");
const ejs = require("ejs");
const path = require("path");

exports.postNew = async function (req, res) {
  console.log("nnnnnn", req.body);
  const {
    name,
    price,
    addedby,
    image,
    subcatagoryid,
    subsubcatagoryid,
    options,
  } = req.body;
  if (
    !name ||
    !price ||
    !image ||
    !addedby ||
    !subcatagoryid ||
    !subsubcatagoryid ||
    !options
  ) {
    return res.status(422).json({
      message: "All feilds are required",
    });
  }
  try {
    const product = new Products({
      name: name,
      price: price,
      addedby: addedby,
      image: image,
      subcatagoryid: subcatagoryid,
      subsubcatagoryid: subsubcatagoryid,
      options: options,
    });
    const products = await product.save();
    res.status(200).json({ message: "success", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};

exports.AllProductsOfAdmin = async function (req, res) {
  try {
    console.log("Before Products.find()");
    const products = await Products.find({ addedby: "admin" });
    console.log("After Products.find()");
    res.status(200).json({ message: "Getting", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};

exports.AllProductsofSeller = async function (req, res) {
  try {
    console.log("Before Products.find()");
    const products = await Products.find({ addedby: "seller" });
    console.log("After Products.find()");
    res.status(200).json({ message: "Getting", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};
exports.GetSingleProduct = async function (req, res) {
  console.log("abc=====", req.params.id);
  let searchQuery = req.params.id;
  try {
    const products = await Products.find({
      item: { $regex: new RegExp(searchQuery, "i") },
    });
    res.status(200).json({ message: "Success", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};

exports.getSingleProductbyid = async function (req, res) {
  console.log("abc=====", req.params.id);
  let searchQuery = req.params.id;
  try {
    const products = await Products.findOne({ _id: searchQuery });
    res.status(200).json({ message: "Success", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};

exports.getDataByID = async function (req, res) {
  let ID = req.params.id;
  try {
    const products = await Products.find({ _id: ID });
    res.status(200).json({ message: "Success", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};

exports.getDataByName = async function (req, res) {
  let name = req.params.name;
  console.log("ac=====", name);
  try {
    const SCatagory = await SubCatagory.findOne({ subcatagory: name });
    console.log("SSCatagory====", SCatagory._id.toString());
    const products = await Products.find({
      subcatagoryid: SCatagory._id.toString(),
    });
    res.status(200).json({ message: "Success", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};

exports.getDataByName1 = async function (req, res) {
  let name = req.params.name;
  let id = req.query.id;
  // console.log("product id ", id);
  console.log("ac=====", name);
  try {
    const SCatagory = await SubCatagory.findOne({ subcatagory: name });
    const products = await Products.find({
      subcatagoryid: SCatagory._id.toString(),
    });

    console.log(SCatagory);

    for (let i = 0; i < products.length; i++) {
      const subSubCategoryId = products[i].subsubcatagoryid;
      const subSubCatData = await SubSubCatagory.findOne({
        _id: subSubCategoryId,
      });

      // console.log("Product subcategory", subSubCategoryId);

      // If subSubCatData is found and it contains the filter field
      if (subSubCatData && subSubCatData.filter) {
        products[i] = { ...products[i]._doc, filter: subSubCatData.filter };
      }
    }
    console.log("=========================================", products);
    res.status(200).json({ message: "Success", products });
  } catch (error) {
    console.log("is match 1st error===>>>", error);
    res.status(404).json({ success: false, message: error.message });
  }
};

exports.DeleteSinglProduct = async function (req, res) {
  let ID = req.params.id;
  try {
    Products.deleteOne({ _id: ID }, (err, response) => {
      if (response === null) {
        res.json({ message: "User Not Found" });
      } else {
        console.log("user found");
        res.status(200).json({ response, message: "SuccessDelete" });
      }
    });
  } catch (error) {
    console.log("is match 1st error===>>>");
    res.status(404).json({ success: false, message: error.message });
  }
};
